function [y,wslines] = seededwatershedcut(x,seeds);
% [y,wslines] = seededwatershedcut(x,seeds)
%
% Region splitting by the seeded watershed transformation.
%
% In:
%  x          binary image
%  seeds      seeds
%
% Out:
%  y          binary image with split regions
%  wslines    watershed lines
%
% Antti Niemist 2009/04/02

distance = bwdist(x); % objects are ones, background zeros
distance2 = imimposemin(distance,seeds); % impose minima at seeds
L = watershed(distance2); % watershed transformation
y = L&x; % apply watershed lines on the image
wslines = ~L;
